-- universelles Script fr eine neue/vorhandene Anlage von Parry36.
-- Anlage "Rund um Dortmund" von BR53 - Heinrich	

local t  = 0
math.randomseed(os.time())
require("P36_Tool_Box")
require("Slot_tab_Data")        

print("\n Zeitstempel:  ", P36_time(), ",\n Anlage: Rund um Dortmund HBF")
print(" EEP Version:  ", EEPVer, " Lua Version:  ", _VERSION, "\n")

sloteinlesen()      -- beim Anlagenstart die Daten einlesen
info_tabData()

-- Routenzusammenfassung nur als Beispiele
local a_routenG = {"Gueter","Gefahrgut","Kohlen"} 
local a_routenP = {"ICE","Personen","Regional","Sonderfahrt"}
local a_routenR = {"Personen","Regional","Wende"}
local a_routenD = {"Personen", "D-Zug"}
local a_routenI = {"ICE", "Regional", "IC"}
-- Tabelle der Fahrstrassen-Beschreibung 
local a_znSlot = {
				[192] = {trigger = true,        --------- generieren von Funktionen
							s_text  = "angefordert, von Ost nach Nord 2 - Depot 9",
							routen  = {{"F_Zg_41", "I_Zg_41" , "R_Zg_41", "R_Zg_51",}, a_routenG  },
							f_wege  = { {2}, {3},  },
							on_text = {"FS_192, geschaltet, Ost nach Sd-West ber Dortmund",
										"FS_192, geschaltet, Ost nach Nord 2",} },
				[201] = {trigger = true,       ---------  
							s_text  = "angefordert, Dortmund HBF aus Ost",
							routen  = {{"F_Zg_41"}, {"R_Zg_41"}, {"I_Zg_41"},{"F_Zg_51", "R_Zg_51"},},
							f_wege  = { {2,3}, {4},{5}, {7,6}, },
							on_text = {"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 10",
										"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 8",
										"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 16",
										"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 11",
										"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 23",
										"FS_201, geschaltet, Dortmund HBF, Einfahrt Ost nach Gleis 21",} },
				[230] = {trigger = true,        ---------
							s_text  = "angefordert, Dortmund HBF aus Sd-West",
							routen  = {"F_Zg_41", "R_Zg_41","I_Zg_41", "S_Zg_40", "F_Zg_74", "I_Zg_40",},
							f_wege  = { {3,4},{3}, {2}, {5,6},{4}, {2}, },
							on_text = {"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 10",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 8",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 16",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 16",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 7",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 6",
										"FS_230, geschaltet, Dortmund HBF, Einfahrt Sd-West nach Gleis 16",} },
				[235] = {trigger = true,       ---------  
							s_text  = "angefordert, Dortmund HBF aus Ost",
							routen  = {{"F_Zg_41", "I_Zg_41" , "R_Zg_41" }, {"F_Zg_74"},},
							f_wege  = { {2}, {3}, },
							on_text = {"FS_235, geschaltet, Dortmund HBF, Ausfahrt nach Ost",
										"FS_235, geschaltet, Dortmund HBF, Ausfahrt nach Nord-Ost",} },
				[196] = {trigger = true,        --------- 
							s_text  = "angefordert, Strecke von Ost > Sd-West ber Dortmund HBF",
							routen  = {{"F_Zg_41", "I_Zg_41" , "R_Zg_41", "R_Zg_51"}, a_routenG },
							f_wege  = { {2}, {3}, },
							on_text = {"FS_196, geschaltet, Strecke Ost > Sd-West, ber Dortmund HBF",
										"FS_196, geschaltet, Strecke Ost > Sd-West, ber Dortmund HBF",
										"FS_196, geschaltet, Strecke Ost > Sd-West, Gueter nach Sd-West",} },
				[571] = {trigger = true,       ---------  
							s_text  = "angefordert, Dortmund HBF aus Sd-West",
							routen  = {{"F_Zg_41", "I_Zg_41" , "R_Zg_41" }, {"I_Zg_40"},},
							f_wege  = { {2}, {3}, },
							on_text = {"FS_571, geschaltet, Dortmund HBF, Ausfahrt nach Ost",
										"FS_571, geschaltet, Dortmund HBF, Ausfahrt nach Betriebswerk",} },
				[596] = {trigger = true,        --------- 
							s_text  = "angefordert, Depot 7 > Sd-West - Depot 9",
							routen  = {{"R_Zg_70", "F_Zg_74"  }, {"Gueter_97"}}, 
							f_wege  = { {2}, {3}, },
							on_text = {"FS_596, geschaltet, von Depot 7, nach Dortmund HBF",
										"FS_596, geschaltet, von Depot 7, Depot 9 Gueter",} },
				[611] = {trigger = true,        --------- 
							s_text  = "angefordert, Dortmund HBF aus Sd 3",
							routen  = {"W_Zg_30", "S_Zg_30" },
							f_wege  = { {2,3}, {4},  },
							on_text = {"FS_611, geschaltet, Einfahrt von Sd 3, nach Gleis 3",
										"FS_611, geschaltet, Einfahrt von Sd 3, nach Gleis 4",
										"FS_611, geschaltet, Einfahrt von Sd 3, nach Gleis 5",} },
				[623] = {trigger = true,        --------- 
							s_text  = "angefordert, Dortmund HBF aus Sd 2",
							routen  = { "W_Zg_30", "S_Zg_20" },
							f_wege  = { {2}, {3},  },
							on_text = {"FS_623, geschaltet, Ausfahrt, nach Sd 3",
										"FS_623, geschaltet, Ausfahrt, nach Sd 2",} },
				[641] = {trigger = true,        --------- 
							s_text  = "angefordert, Dortmund HBF aus Sd 2",
							routen  = {{"S_Zg_20" }, {"R_Zg_150"}}, 
							f_wege  = { {2,3}, {4}, },
							on_text = {"FS_641, geschaltet, Einfahrt von Sd 2, nach Gleis 2",
										"FS_641, geschaltet, Einfahrt von Sd 2, nach Gleis 3",
										"FS_641, geschaltet, Einfahrt von Bhf Sd, nach Gleis 7",} },				
				[643] = {trigger = true,        --------- 
							s_text  = "angefordert, Strecke von Ost > Sd-West ber Dortmund HBF",
							routen  = {{"S_Zg_20"}, { "R_Zg_150"}},
							f_wege  = { {2}, {3}, },
							on_text = {"FS_643, geschaltet, von Dortmund, nach Sd-West",
										"FS_643, geschaltet, von Dortmund, Depot 15 ber Do-Dorstfeld",} },
				[657] = {trigger = true,        --------- 
							s_text  = "angefordert, Dortmund HBF > Sd-West",
							routen  = {{"S_Zg_40" }, {"R_Zg_150"}}, 
							f_wege  = { {2}, {3}, },
							on_text = {"FS_657, geschaltet, Ausfahrt Dortmund, nach Sd-West",
										"FS_657, geschaltet, Ausfahrt Dortmund, nach Do-Dorstfeld",} },
				[930] = {trigger = true,        --------- 
							s_text  = "angefordert, Gueter > Depot 9 oder 7",
							routen  = {{"Gueter" }, {"Gueter_97"}, {"Gueter_9H"}, }, 
							f_wege  = { {2}, {3}, {4, 5,6,7,8} },
							on_text = {"FS_930, geschaltet, von Depot 9, nach Ost",
										"FS_930, geschaltet, von Depot 9, Depot 7",
										"FS_930, geschaltet, von Depot 9, Abstellgleis Rbf",} },
				[1032] = {trigger = true,        --------- 
							s_text  = "angefordert, Nord-Ost",
							routen  = {{"R_Zg_70" }, {"F_Zg_74"}}, 
							f_wege  = { {2}, {3}, },
							on_text = {"FS_1032, geschaltet, Einfahrt Dortmund, nach Gleis 31",
										"FS_1032, geschaltet, Einfahrt Dortmund, nach Gleis 8",} },
				[1042] = {trigger = true,       ---------  
							s_text  = "angefordert, Dortmund HBF aus Ost",
							routen  = {"I_Zg_40",},
							f_wege  = { {2, 3, 4, 5,}, },
							on_text = {"FS_1042, geschaltet, Betriebswerk, Halle 1 Tor 3",
										"FS_1042, geschaltet, Betriebswerk, Halle 1 Tor 4",} },
				[1314] = {trigger = true,       -- Hafenbetrieb  
							s_text  = "angefordert, Hafenbetrieb",
							routen  = {{"Hafen_Kohle"},{"Hafen_Stahl"}, {"Hafen_Schrott"},{"Hafen_Tank"}, {"Hafen_Gueter"}, },
							f_wege  = { {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10},},
							on_text = {"FS_1314, geschaltet, Hafenbetrieb, Kohlelager Gleis 1",
										"FS_1314, geschaltet, Hafenbetrieb, Kohlelager Gleis 2 Innenbereich",
										"FS_1314, geschaltet, Hafenbetrieb, Stahllager Gleis 1 Kaimauer",
										"FS_1314, geschaltet, Hafenbetrieb, Stahllager Gleis 2",
										"FS_1314, geschaltet, Hafenbetrieb, Schrottlager Gleis 1 Kaimauer",
										"FS_1314, geschaltet, Hafenbetrieb, Schrottlager Gleis 2",
										"FS_1314, geschaltet, Hafenbetrieb, Tanklager Gleis 1",
										"FS_1314, geschaltet, Hafenbetrieb, Tanklager Gleis 2 Innenbereich",
										"FS_1314, geschaltet, Hafenbetrieb, Tanklager Gleis 3 Gter",} },
				[1348] = {trigger = true,       --------- Hafenbetrieb 
							s_text  = "angefordert, Rangierbahnhof Mitte",
							routen  = {{"Hafen_Kohle","Hafen_Stahl", "Hafen_Schrott"},{"Hafen_Tank", "Hafen_Gueter", "Hafen_Container"},},
							f_wege  = { {2, 3, 4, 5, 6}, {7, 8, 9, 10, 11}, },
							on_text = {"FS_1348, geschaltet, Rbhf Mitte, Gleis 1",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 2",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 3",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 4",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 5",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 6",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 7",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 8",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 9",
										"FS_1348, geschaltet, Rbhf Mitte, Gleis 10",} },
				[1399] = {trigger = true,       --------- Hafenbetrieb 
							s_text  = "angefordert, Hafen Ost",
							routen  = {{"Hafen_Kohle","Hafen_Stahl", "Hafen_Schrott", "Hafen_Tank", "Hafen_Gueter"},{"Hafen_Container"},{"Gueter_9H"},},
							f_wege  = { {2,}, {3}, {4} },
							on_text = {"FS_1399, geschaltet, Rbhf Mitte, Richtung Gewerbe",
										"FS_1399, geschaltet, Rbhf Mitte, Hafen Sd-Ost", 
										"FS_1399, geschaltet, Rbhf Mitte, > Depot 9",} },
				} -- 18
 
-- Einweg - Fahrstrassen 
local a_pool = { 194, 198, 203, 206, 212, 213, 217, 220, 222, 226, 236, 241, 243, 245, 247, 					--15
				251, 253, 257, 262, 263, 302, 305, 314, 316, 320, 323, 328, 331, 334, 337, 					--15
				586, 589, 591, 594, 598, 600, 617, 624, 625, 630, 634, 636, 639, 652,   						--15
				919, 922, 924, 927, 933, 936, 945, 954, 956, 959, 963, 968, 969,  						      --13
				975, 978, 982, 985, 990, 991, 994, 997, 1006, 1007, 1009, 1013, 1016, 1019, 1022, 1027,		--16
				1037, 1046, 1049, 1051, 1055, 1057, 1059, 1063, 1070, 1301, 1304, 1307, 1478, 1479,  		--14
				1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344,1345, 1379, 1380, 1381, 1382, 			--Hafengebiet -14
				1383, 1384, 1385, 1386, 1387, 1388, 1400, 1407, 1408, 1411, 1416, 1462, 1453, 1454, 1465,	--Hafengebiet -15
				1466, 1467				} 																--Hafengebiet -2
				
				-- 137 FS - 193 Fw
				
--> eventuelle Sonderfunktionen die getriggert sollen 
--[[}
per Referenzbergabe
function a_pool:Sonderfunktion()
    body ...
end
 ]]
------------ generieren aller Funktionen in a_znSlot -----------
for k, v in pairs(a_znSlot)  do
    
    if   v.trigger    then                  -- Funktionen nur generieren wenn trigger == true
        _ENV["FS_"..k] = function()         -- Funktions-Namen z.B. FS_412 
            local hResult, s_route 
            hResult, s_route = load_tabData(k)          -- Route aus Tabelle laden            
            if  hResult and  EEPGetSignal(k)  == 1   then   -- anmelden prfen
                for n = 1, #v.routen  do                -- Tabelle routen iterieren
                    if  SelectRoute( s_route, v.routen[n])     then 
                        EEPSetSignal(k, fw_random(v.f_wege[n]) , 1)	    -- mit Callback aufrufen
                    end
                end
            end    
        end
        
        v.func = _ENV["FS_"..k]     -- Referenzbergabe der Funktionen an a_znSlot    
        EEPRegisterSignal(k)        -- Signale registrieren trigger == true        
        
        _ENV["EEPOnSignal_"..k] = function(_status)
            if  _status > 1 then
                del_tabData(k)
                print(v.on_text[EEPGetSignal(k)-1])
            end 
        end
    end        
end
--##########----Ende a_znSlot Funktionen-----############

-- Aufruf in der EEPMain() im Anlagen-Script einsetzen!!!!
function inEEPMain()
    t = t + 1
        FS_schalten()
        
    if t%600 == 0 then      
        info_tabData()      -- Info alle 2 Min. anzeigen
    end        
end

function FS_schalten()		
    for k , v in pairs(table2rand(a_znSlot))	do
        if  not v.func   then          -- keine Funktion vorgegeben  
            if	load_tabData(k)	then  EEPSetSignal(k, 2) end 
        elseif  type(v.func) == "function"   then        
            v.func()
        end    
	end
    
    for _, v in pairs(table2rand(a_pool))	do
        if  type(v) == "number"  then
            if	load_tabData(v)	then  EEPSetSignal(v, 2) end 
        elseif type(v) == "function"  then
            v()
        end    
	end	
end

-- Anmelden im KP 
function anmelden(Fs_Id, Zn)
    if not Zn then Zn = Zugname end	
    local hResult, s_route = EEPGetTrainRoute(Zn)
    if hResult  then
        set_tabData(Fs_Id, s_route )
        if not a_znSlot[Fs_Id]    then
            --print("FS_", Fs_Id, ", angefordert, Zug: ", Zn, ",\nRoute: ", s_route)
        else
            --print("FS_", Fs_Id, ", ",a_znSlot[Fs_Id].s_text, "\nZug: ", Zn, ", Route: ", s_route)
        end    
    end
end

-- Abmelden im KP
function abmelden(Fs_Id, Zn)
    if not Zn then  Zn = Zugname   end 
    del_tabData(Fs_Id)
    if not a_znSlot[Fs_Id]    then
        -- print("FS_", Fs_Id, ", geschaltet, Zug: ", Zn)
    end    
end
----- Ausfahrten aus Depot fr Anzeige im GBS
a_depot = { ["Depot_1"]  = {s_text = "Zugausfahrt aus Depot 1 - Ost > Sd-West ber Dortmund HBF",
                            sig_Id = 1197 },
            ["Depot_2"]  = {s_text = "Zugausfahrt aus Depot 2 - Sd 2 nach Dortmund HBF",
                            sig_Id = 1198 },
            ["Depot_3"]  = {s_text = "Zugausfahrt aus Depot 3 - Sd 3 nach Dortmund HBF",
                            sig_Id = 1199 },
            ["Depot_4"]  = {s_text = "Zugausfahrt aus Depot 4 - Sd-West > Ost ber Dortmund HBF",
                            sig_Id = 1200 },
            ["Depot_5"]  = {s_text = "Zugausfahrt aus Depot 5 - West > Ost ber Dortmund HBF",
                            sig_Id = 1201 },
            ["Depot_6"]  = {s_text = "Zugausfahrt aus Depot 6 - Nord-West nach Dortmund HBF",
                            sig_Id = 1202 },
            ["Depot_7"]  = {s_text = "Zugausfahrt aus Depot 7 - Nord-Ost nach Dortmund HBF",
                            sig_Id = 1203 },
            ["Depot_8"]  = {s_text = "Zugausfahrt aus Depot 8 - Gter von Ost nach Sd-West ber Dortmund HBF",
                            sig_Id = 1204 },
            ["Depot_9"]  = {s_text = "Zugausfahrt aus Depot 9 - Gter von Ost nach Sd-West ber Dortmund HBF",
                            sig_Id = 1205 },
            ["Depot_10"] = {s_text = "Zugausfahrt aus Depot 10 - Nord 1 nach Ost",
                            sig_Id = 1206 },
            ["Depot_11"] = {s_text = "Zugausfahrt aus Depot 11",
                            sig_Id = 1207 },
            ["Depot_12"] = {s_text = "Zugausfahrt aus Depot 12 > Sd-West",
                            sig_Id = 1208 },
            ["Depot_13"] = {s_text = "Zugausfahrt aus Depot 13 > Sd",
                            sig_Id = 1209 },
            ["Depot_14"] = {s_text = "Zugausfahrt aus Depot 14 > Nord",
                            sig_Id = 1210 },
            ["Depot_15"] = {s_text = "Zugausfahrt aus Depot 15 > Dortmund HBF",
                            sig_Id = 1211 },
            --["Hafenbahn_1"] = {s_text = "Zugausfahrt aus Depot 15 > Dortmund HBF",
                               --sig_Id = 1 },
        }
        
for k, v in pairs(a_depot)  do
    _ENV[k] = function() 
        print(v.s_text)
        EEPSetSignal(v.sig_Id, -1)
    end
end


